using UnityEngine;
using UnityEditor;

namespace Hive.Unity.Editor
{

    [InitializeOnLoad]
    public class HiveIosEditorLoader
    {

        static HiveIosEditorLoader()
        {
            AutoAddScriptingSymbol();
        }

        private static void AutoAddScriptingSymbol()
        {
            // HAS_IOS_COMPONENT
            // HAS_ANDROID_COMPONENT
            // HAS_WINDOWS_COMPONENT
            const string symbolToAdd = "HAS_IOS_COMPONENT";
            BuildTargetGroup group = EditorUserBuildSettings.selectedBuildTargetGroup;

            string defines = PlayerSettings.GetScriptingDefineSymbolsForGroup(group);

            if (!defines.Contains(symbolToAdd))
            {
                string newDefines = string.IsNullOrEmpty(defines) ? symbolToAdd : $"{defines};{symbolToAdd}";
                PlayerSettings.SetScriptingDefineSymbolsForGroup(group, newDefines);
            }
        }

    }

}